/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.Plot;
import cds.aladin.PointD;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;

public class PlanTMoc
extends PlanMoc {
    protected Moc[] arrayTimeMoc = null;
    protected ArrayList<MyRect> lastRectDrawn = null;
    protected boolean mocTimeLowReset = false;
    private int lastTimeOrderDrawn = -1;
    protected double oz = -1.0;
    private static final int MAXDRAWCELL = 300;
    private static final int MINLIMIT = 9;
    private double[] lastDrawTimeRange = new double[]{Double.NaN, Double.NaN};
    public static final int BAND = 20;
    public static final int MARGE = 30;

    public PlanTMoc(Aladin a) {
        super(a);
        this.type = 23;
    }

    protected PlanTMoc(Aladin aladin, MyInputStream in, String label, String url) {
        super(aladin);
        this.dis = in;
        this.url = url;
        this.useCache = false;
        this.type = 23;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "TMOC";
        }
        this.setLabel(label);
        Aladin.trace(3, "TMOC creation: " + Plan.Tp[this.type]);
        this.suite();
    }

    protected PlanTMoc(Aladin aladin, TMoc moc, String label, String url) {
        super(aladin);
        this.moc = moc;
        this.url = url;
        this.useCache = false;
        this.type = 23;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "TMOC";
        }
        this.setLabel(label);
        Aladin.trace(3, "TMOC creation: " + Plan.Tp[this.type]);
        this.suite();
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        boolean isEmpty = this.moc.isEmpty();
        if (!isEmpty) {
            PlanTMoc.ADD(buf, "\n* Start: ", Astrodate.JDToDate(((TMoc)this.moc).getTimeMin()));
            PlanTMoc.ADD(buf, "\n* End: ", Astrodate.JDToDate(((TMoc)this.moc).getTimeMax()));
        }
        PlanTMoc.ADD(buf, "\n* # ranges: ", this.moc.getNbRanges() + "");
        int order = PlanTMoc.getRealMaxOrder((TMoc)this.moc);
        int drawOrder = isEmpty ? -1 : this.getDrawOrder();
        PlanTMoc.ADD(buf, "\n", "* Resolution: " + Util.getTemps(TMoc.getDuration(order)));
        PlanTMoc.ADD(buf, "\n", "* Order: " + (order == drawOrder ? order + "" : drawOrder + "/" + order));
        if (isEmpty) {
            PlanTMoc.ADD(buf, "\n \nRAM: ", Util.getUnitDisk(this.moc.getMem()));
        }
    }

    @Override
    protected boolean isTime() {
        return true;
    }

    protected double getTimeMin() {
        double tmin = ((TMoc)this.moc).getTimeMin();
        if (tmin == -1.0) {
            tmin = Double.NaN;
        }
        return tmin;
    }

    protected double getTimeMax() {
        double tmax = ((TMoc)this.moc).getTimeMax();
        if (tmax == -1.0) {
            tmax = Double.NaN;
        }
        return tmax;
    }

    @Override
    protected double[] getTimeRange() {
        return new double[]{this.getTimeMin(), this.getTimeMax()};
    }

    @Override
    protected boolean waitForPlan() {
        if (this.dis != null) {
            this.error = null;
            try {
                if (this.moc == null && this.dis != null) {
                    this.moc = new TMoc();
                    this.readMoc(this.moc, this.dis);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                this.error = "MOC error";
                return false;
            }
        }
        return true;
    }

    protected TMoc getTimeMoc() {
        return (TMoc)this.moc;
    }

    protected static int getRealMaxOrder(Moc1D m) {
        return m.getMocOrder();
    }

    protected boolean isSpaceModified() {
        return false;
    }

    protected void mocTimeLowReset() {
        this.mocTimeLowReset = true;
    }

    @Override
    protected int getDrawOrder() {
        return this.lastTimeOrderDrawn;
    }

    protected Moc getTimeMocLow(int order, int gapOrder) {
        TMoc moc = this.getTimeMoc();
        if (Aladin.NOGUI) {
            return moc;
        }
        if ((order += gapOrder) > moc.getMocOrder()) {
            order = moc.getMocOrder();
        }
        if (order < 0) {
            order = 0;
        }
        if (this.arrayTimeMoc == null || this.arrayTimeMoc[order] == null || this.mocTimeLowReset) {
            if (this.arrayTimeMoc == null) {
                this.arrayTimeMoc = new TMoc[62];
            }
            this.arrayTimeMoc[order] = new TMoc();
            int myOrder = order;
            try {
                int myMo = moc.getMocOrder();
                Aladin.trace(4, "PlanTMoc.getTimeMocLow(" + myOrder + ") running...");
                TMoc mocLow = myOrder == myMo ? moc : moc.clone();
                mocLow.setMocOrder(myOrder);
                this.arrayTimeMoc[myOrder] = mocLow;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Aladin.trace(4, "PlanTMoc.getTimeMocLow(" + myOrder + ") done !");
            this.askForRepaint();
        }
        if (this.arrayTimeMoc[order].isEmpty()) {
            int i;
            this.isLoading = true;
            for (i = order; i >= 9 && (this.arrayTimeMoc[i] == null || this.arrayTimeMoc[i].isEmpty()); --i) {
            }
            if (i >= 9) {
                order = i;
            }
        } else {
            this.isLoading = false;
        }
        this.lastTimeOrderDrawn = order;
        return this.arrayTimeMoc[order];
    }

    protected int getDrawingOrder(ViewSimple v) {
        int o;
        Plot plot = v.plot;
        double dureeView = plot.getMax() - plot.getMin();
        for (o = 61; o >= 9; --o) {
            double nbCell = dureeView / ((double)TMoc.getDuration(o) / 8.64E10);
            if (!(nbCell < 300.0)) continue;
            return o;
        }
        return o;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        if (!v.isPlotTime()) {
            return;
        }
        this.drawInTimeView(g, v);
    }

    protected double[] getLastDrawTimeRange() {
        return this.lastDrawTimeRange;
    }

    protected double getLastDrawTmin() {
        return this.lastDrawTimeRange[0];
    }

    protected double getLastDrawTmax() {
        return this.lastDrawTimeRange[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawInTimeView(Graphics g, ViewSimple v) {
        if (this.moc == null) {
            return;
        }
        Plot plot = v.plot;
        boolean flagBorder = this.isDrawingBorder();
        boolean flagfillIn = this.isDrawingFillIn();
        g.setColor(this.c);
        double tmin = plot.getMin();
        double tmax = plot.getMax();
        int drawingOrder = this.moc.getNbRanges() < 300 ? this.moc.getTimeOrder() : this.getDrawingOrder(v);
        TMoc lowMoc = (TMoc)this.getTimeMocLow(drawingOrder, this.gapOrder);
        this.mocTimeLowReset = false;
        Iterator<long[]> it = lowMoc.jdIterator(tmin, tmax);
        ArrayList<MyRect> a = new ArrayList<MyRect>();
        while (it.hasNext()) {
            a.add(this.computeRectangle(plot, drawingOrder, it.next()));
        }
        if (flagfillIn && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Composite composite = g2d.getComposite();
            try {
                g2d.setComposite(Util.getImageComposite(this.getOpacityLevel() * this.getFactorOpacity()));
                for (RectangleD rectangleD : a) {
                    if (flagBorder && rectangleD.width <= 1.0) continue;
                    g.fillRect((int)rectangleD.x, (int)rectangleD.y, (int)rectangleD.width, (int)rectangleD.height);
                }
            }
            finally {
                g2d.setComposite(composite);
            }
        }
        if (flagBorder) {
            for (RectangleD rectangleD : a) {
                g.drawRect((int)rectangleD.x, (int)rectangleD.y, (int)rectangleD.width, (int)rectangleD.height);
            }
        }
        if (v == this.aladin.view.getMouseView()) {
            this.lastRectDrawn = a;
        }
    }

    @Override
    protected int getTimeStackIndex() {
        return this.timeStackIndex;
    }

    private MyRect computeRectangle(Plot plot, int drawingOrder, long[] range) {
        MyRect r = new MyRect();
        r.start = range[0];
        r.end = range[1];
        r.order = drawingOrder;
        Coord c = new Coord();
        c.al = (double)r.start / 8.64E10;
        c.del = 0.0;
        plot.getProj().getXY(c);
        PointD a = plot.viewSimple.getPositionInView(c.x, c.y);
        c.al = (double)r.end / 8.64E10;
        plot.getProj().getXY(c);
        PointD b = plot.viewSimple.getPositionInView(c.x, c.y);
        r.x = a.x;
        r.y = plot.viewSimple.getHeight() - 15 * (this.getTimeStackIndex() + 1) - 30;
        r.width = Math.abs(b.x - a.x);
        if (r.width < 1.0) {
            r.width = 1.0;
        }
        r.height = 20.0;
        return r;
    }

    @Override
    protected void planReady(boolean ready) {
        this.setPourcent(-1.0);
        this.active = true;
        this.flagOk = ready;
        this.aladin.synchroPlan.stop(this.startingTaskId);
        this.flagWaitTarget = false;
        this.flagProcessing = false;
        this.planReadyPost();
        this.aladin.view.repaintAll();
    }

    protected void planReadyPost() {
        this.aladin.view.createView4TMOC(this);
    }

    class MyRect
    extends RectangleD {
        long start;
        long end;
        int order;

        MyRect() {
        }

        MyRect(double x, double y, double w, double h) {
            super(x, y, w, h);
        }
    }
}

